#! /bin/sh
#
#   makeiso.sh -- ϡɥǥõѥ֡CDκ
#
#   revision history:
#	0.0: Oct. 26, 2001 by Dai ISHIJIMA
#	0.1: Oct. 22, 2002 (add diskinfo)
#	0.2: May   1, 2004 (4.8R, disklabel, random data)
#	0.3: May   1, 2004 (makefd.sh -> makeiso.sh)
#	0.4: Jun. 15, 2004 (dialog, cd9660)
#	0.5: Jun. 19, 2004 (ե륵ǡ)
#	0.6: Jun. 27, 2004 (ǰõ, fine-erase.sh)
#	0.7: Oct. 18, 2004 (ISO᡼)
#	0.8: Jun. 19, 2005 (CDޥ, PXEѥͥ)
#	0.9: Jul.  8, 2005 (õå)
#	1.0: Jun. 29, 2006 (v07pre-1, 4.11R)
#	1.1: Aug.  6, 2006 (v07pre-2, 4.11R, CD֡Ȥʤݤн)
#	1.2: Sep. 18, 2006 (v07pre-3, 4.11R, PXE֡Ȥ /var ʤݤн)
#	1.3: Dec. 21, 2006 (v07pre-4, SJISɥ)
#	1.4: Feb. 10, 2007 (v08pre-1, ǥؤΥϿ)
#	1.5: Feb. 15, 2007 (nkfץߥ)
#	1.6: Feb. 16, 2007 (ͥȥե륷ƥʬΥ)
#	1.7: Sep. 12, 2007 (v09pre-1)
#	1.9: Sep. 17, 2007 (v09pre-2)
#	2.0: Oct.  7, 2007 (v09pre-3, /etc/fstab)
#	2.1: Dec. 23, 2007 (v09pre-4, copy.sh¾Сշ׻)
#	2.2: Jan.  2, 2008 (v09pre-5, ե륵, ե, etc.)
#	2.3: Feb. 10, 2008 (v09)
#	2.4: Apr. 19, 2009 (v10pre-1)
#	2.5: Apr. 25, 2009 (v10pre-2)
#	2.6: Nov.  7, 2010 (v11pre-1), FreeBSD 7.3R
#	2.7: Apr. 11, 2011 (v11pre-2), kon2fixed
#	2.8: Apr. 16, 2011 (v11pre-3), USB
#	2.9: Dec. 22, 2012 (v12pre-1), SMART
#	3.0: Jan. 21, 2013 (v12pre-2), USB image
#	3.1: May   5, 2013 (v13pre-1), FreeBSD 8.3R, md0c -> md0a
#	3.1: Oct. 10, 2013 (v13pre-3), fix kon fatal error, libusb.so
#	3.2: Nov.  7, 2013 (v13pre-4), xhci.ko
#	3.3: Dec.  7, 2013 (v13pre-5), mfi(4), mfid
#	3.4: Mar. 22, 2014 (v14), Сֹե뤫äƤ
#	3.5: May  11, 2014 (v14, shell-on)
#	3.6: Aug.  2, 2015 (v15pre-1), FreeBSD 9.3R
#	3.7: Aug. 30, 2015 (v15pre-2), FreeBSD 9.3R, USB
#	3.8: Jul. 26, 2016 (v16pre-1), FreeBSD 10.3R, vt(4)/sc(4)+kon2
#	3.9: Sep. 10, 2016 (v16pre-2)
#	4.0: Sep. 19, 2016 (v16pre-3), USB again
#	4.1: Dec.  4, 2016 (v16pre-4), fix /root, $PATH
#	4.2: Jan.  2, 2017 (v16 official release)
#	4.3: Mar. 13, 2017 (v16 test#1)	
#	4.4: Mar. 13, 2017 (v16 test#2)	
#	4.5: Aug. 12, 2017 (v17pre-1), FreeBSD 11.1R
#	4.7: Sep. 18, 2017 (v17pre-2), FreeBSD 11.1R, USB
#	4.8: Jul. 17, 2018 (v18pre-0), FreeBSD 11.2R
#	4.9: Sep. 23, 2019 (v19pre-0), FreeBSD 12.0R
#	5.0: Mar.  1, 2020 (v20pre-0), FreeBSD 11.3R
#	5.1: May  17, 2020 (v20pre-1), FreeBSD 11.3R, floppy
#	5.2: Nov. 10, 2020 (v20pre-2), present
#	5.3: Feb. 25, 2021 (v20), ̸
#	5.4: Aug.  7, 2021 (v21-pre), FreeBSD 12.2R
#	5.5: Sep.  5, 2021 (v21-pre-2), FreeBSD 12.2R
#	5.5: Sep. 18, 2021 (v21-pre-3), FreeBSD 12.2R, over 2G RAM
#	5.6: Oct. 16, 2021 (v21-pre-4), FreeBSD 12.2R, ̸
#	5.7: Nov. 26, 2021 (v21-pre-5), FreeBSD 12.2R, pre UEFI
#	5.8: Aug.  7, 2024 (v24), FreeBSD 13.3R (/usr/src/etc/*)
#	5.9: Jun. 22, 2025 (v25-pre) FreeBSD 14.2R
#

#
#   memo: v1.9, FreeBSD 12.0R ξ硢µǥ֡Ȥʤ
#	-> v2.0  11.3R 
#

#   usage:
#	# sh makeiso.sh [-t|-p|-f|-a|-u]
#		-t:  (tiny)
#		-u:  (tiny) for USB
#		-p: PXE (pxe-boot) (obsolated)
#		-f: ե륵 (full)
#		-a:  (all) (obsolated)
#
#   required install:
#	kern-developer, setc (/etc/source), ports
#
#   required packages/ports:
#	ja-nkf, cdrtools, smartmontools, rsync, ja-kon
#
#   recommended packages/ports:
#	ja-man, ja-mandoc, ja-ng
#
#   required font files:
#	paw16vt.fnt in /usr/local/share/fonts/vt/
#	paw16*.bdf in /usr/local/share/fonts/bdf
#
#

# Ȥꤢư
cd /tmp

# ѥΥå
this="$0"
menudir=`dirname "$this"`
basedir=`dirname "$menudir"`
case "x$basedir" in
	x*v[0-9][0-9])
		;;
	*)
		echo "can't verifty script directory" 1>&2
		exit 1
		;;
esac

# ѥѥ 2025-06-28
mfsroot=/tmp/mdroot
cdfs=${mfsroot}/cdrom

# 2025-06-28
taropts="xvpf"
taropts="xpf"

#
# ɤä??
#
##size=full	# CD-ROM˥ͤᤳС
size=tiny	# ξС
pxe=no
suffix=t
mkusb=NO
case x"$1" in
	x-[afm]*)
		size=full
		pxe=yes
		suffix=m
		withaux="NO"
		withimage="NO"
		withmanual="NO"
		;;
	x-[stp]*)
		size=tiny
		pxe=yes
		suffix=t
		withaux="NO"
		withimage="NO"
		withmanual="NO"
		;;
	x-[T]*)
		size=tiny
		pxe=yes
		suffix=t
		withimage="YES"
		withaux="YES"
		withmanual="NO"
		;;
	x-[M]*)
		size=tiny
		pxe=yes
		suffix=t
		withimage="YES"
		withaux="YES"
		withmanual="YES"
		;;
	x-[u]*)
		size=tiny
		pxe=yes
		suffix=t
		mkusb="YES"
		withaux="NO"
		withimage="NO"
		withmanual="NO"
		;;
esac

# С
version='25'
if [ -r $basedir/version ]; then
	version=`cat $basedir/version`
else
	echo 'unable to set version number' 1>&2
	exit 1
fi

#minor='999'	# 2025-06-22 for v25
#minor='998'	# 2025-08-23 for v25 (2nd, diskinfo, gpart)
#minor='996'	# 2025-08-26
#minor='995'	# 2025-09-20
#minor='994'	# 2025-11-26
if [ -r $basedir/minor ]; then
	minor=`cat $basedir/minor`
fi

# 
output="/tmp/wpout${version}${suffix}.iso"
usbimg="/tmp/wpout${version}${suffix}.img"
basename=`echo $output | sed 's/\.[^.]*$//' | sed 's+^.*/++'`

# ̾쥵ӥ
####credit="𥷥ǧե꡼(̾쥵ӥ)"
####credit="˿⹻Ƴ߼PCǡõե"
credit=''

#
# ܥ塼٥
#      filename-maj-min
#      0123456789abcdef
#      WIPE-OUT-04M_001
#
volsuffix=`echo $suffix | tr a-z A-Z`
volid="WIPEOUT${version}${volsuffix}${minor}"

# ॹ
timestamp=`date '+%Y-%m-%d'`
echo "$volid ($timestamp)" > /tmp/version.txt

# Υե뤽¾֤
srcdir=/home/dai/src/wipe-out/v$version/menu

# floppy
floppydir=/home/dai/src/wipe-out/v$version/floppy

# ͥ
#ident=
#case x${ident} in
#	x)
#		kerndir=/boot/kernel
#		;;
#	x*)
#		kerndir=/boot/kernel.$ident
#		;;
#esac
kerndir=/boot/kernel

# ɬפʤΤϤ?
for f in $srcdir/disksize $kerndir/kernel ; do
	if [ ! -r $f ]; then
		echo "can't open $f" 1>&2
		exit 1
	fi
done

# ԡեȤϤ뤫?
if [ ! -r /usr/local/share/fonts/bdf/paw16k.bdf ]; then
	echo "can't open paw16k.bdf" 1>&2
fi
if [ ! -r /usr/local/share/fonts/vt/paw16vt.fnt ]; then
	echo "can't open paw16vt.fnt" 1>&2
	exit 1
fi

#
# wipe-outΥե뷲
#
rc=rc
binaries="disksize stuff tinydate tinydump check makembr wpout-mbr.boot"
binaries="$binaries shell-on"
binaries="$binaries tread"
binaries="$binaries xd"
binaries="$binaries session"

sources="disksize.c stuff.c tinydate.c tinydump.c check.c makembr.c"
sources="$sources wpout-mbr.s"
sources="$sources shell-on.c"
sources="$sources tread.c"
sources="$sources xd.c session.c"

scripts="startup.sh mainmenu.sh seldisk.sh erase.sh fine-erase.sh"
scripts="$scripts sel-fine.sh verify.sh dump.sh writelog.sh"
scripts="$scripts copy.sh embr.sh crlf.sh floppylog.sh dummyread.sh"
scripts="$scripts kon2start.sh kon2alt.sh"
scripts="$scripts vtstart.sh"
scripts="$scripts vt-alt.sh sgrep"	# 2025-09-20
scripts="$scripts sanitize.sh"
scripts="$scripts alt-menu.sh"
scripts="$scripts scsaver.sh"
scripts="$scripts atasecurity.sh waitsecure.sh"
#scripts="$scripts chime.sh timer.sh poko.sh kuru.sh"
scripts="$scripts chime.sh timer.sh poko.sh"
scripts="$scripts logdev.sh show-elapsed.sh"
scripts="$scripts ncountdown.sh"
misc="info.txt readme.txt help.txt"
misc="$misc mani.txt"
termcap="termcap"
textfiles="$rc $scripts $misc $termcap $sources"
appdir=/home/dai/src/wipe-out/v$version/app
appfiles="README.TXT configure exifrescue exifrescue.c wipe-out.sh"
appfiles="$appfiles xd.c codeconv.c codeconv.h ucs2jis.c ucs2jis.h"

# ------------------------------------------------------------ #
images="wpout08f.flp"
images="$images /wpout08.flp"
images="$images /wpout16t-2016-12-18.iso"
images="$images /wpout16t-2016-12-18.usb"
images="$images /wpout18t-2018-08-08.iso"
images="$images /wpout18t-2018-08-08.usb"
images="$images /wpout20t-2021-10-30.iso"
images="$images /wpout20t-2021-10-30.usb"

# ------------------------------------------------------------ #
#images="NO"	# ǤΥ᡼ե򥳥ԡʤ
images="NO"

#
case x"$mkusb" in
	xYES*)
		withimage="NO"
		images="NO"
		withaux="NO"
		withmanual="NO"
		auxfiles="NO"
		;;
esac

#
case x"$withimage" in
	xNO*)
		images="NO"
		;;
esac

#
#auxfiles="NO"	# ޥΥե򥳥ԡʤ
auxfiles="exifrescue.c"
# 2025-10-11
#auxfiles="$auxfiles dekirun3.pdf"
#auxfiles="$auxfiles wpout25t-2025-09-20.img"
withmanual="NO"
#withmanual="YES"
#
case x"$withaux" in
	xNO*)
		auxfiles="NO"
		;;
	xYES*)
		auxfiles="exifrescue.c"
		;;
esac

case x"$withmanual" in
	xYES*)
		auxfiles="$auxfiles wipe3p.pdf"
		;;
esac

#
# FreeBSDΥƥե
#

# MFS˺ǥ쥯ȥ (/ )
#dirs="bin sbin lib libexec etc dev tmp"
dirs="bin sbin lib libexec etc dev tmp root proc"
dirs="$dirs usr/bin usr/sbin usr/lib"
dirs="$dirs usr/local/bin usr/local/etc usr/local/sbin"
dirs="$dirs usr/local/share/fonts/vt"
#dirs="$dirs a mnt cdrom floppy"
dirs="$dirs a mnt cdrom floppy fd-mode"
dirs="$dirs var/run var/tmp var/db var/log"
dirs="$dirs usr/share/misc"
dirs="$dirs wipeout"

#
# MFS˥ԡե
#

# /bin
bins="sh echo dd test expr cat sleep"
bins="$bins cp date mkdir sync"
bins="$bins csh df hostname kill ln ls mv ps rm"

# /sbin
sbins="init ldconfig mount dmesg mount_cd9660"
sbins="$sbins umount shutdown"
#sbins="$sbins mount_msdosfs mount_nfs mount_ntfs"
sbins="$sbins mount_msdosfs mount_nfs"
sbins="$sbins camcontrol"
sbins="$sbins ifconfig route ping"
sbins="$sbins kldload"
sbins="$sbins sysctl"
sbins="$sbins gpart"

# /usr/bin
ubins="sed dialog hd id wall tty script"
ubins="$ubins wc"
ubins="$ubins grep tr vi"
ubins="$ubins ftp fetch telnet tftp netstat"
ubins="$ubins touch printf"

# /usr/sbin
usbins="kbdcontrol powerd vidcontrol diskinfo"

# /usr/local/bin
ulbins="kon fld nkf ng"
#ulbins="kon kon2fixed fld nkf ng"
#ulbins="kon fld "

# /usr/local/sbin
ulsbins="smartctl"

cp /dev/null /tmp/libs-ldd.txt
for b in $bins; do
	ldd /bin/$b >> /tmp/libs-ldd.txt
done
for b in $sbins; do
	ldd /sbin/$b >> /tmp/libs-ldd.txt
done
for b in $ubins; do
	ldd /usr/bin/$b >> /tmp/libs-ldd.txt
done
for b in $usbins; do
	ldd /usr/sbin/$b >> /tmp/libs-ldd.txt
done
for b in $ulbins; do
	ldd /usr/local/bin/$b >> /tmp/libs-ldd.txt
done
for b in $ulsbins; do
	ldd /usr/local/sbin/$b >> /tmp/libs-ldd.txt
done

cat /tmp/libs-ldd.txt | grep '=>' |
	awk '{print $3}' | sort | uniq > /tmp/libs-ldd-uniq.txt
#
# ɬפʥ饤֥ ldd(1) ޥɤǳǧ
#

# /lib
#libs="libc.so.? libcrypt.so.? libedit.so.? libncurses.so.? libutil.so.?"
#libs="$libs libkvm.so.? libkiconv.so.? libm.so.?"
#libs="$libs libcam.so.? libgcc_s.so.? libsbuf.so.?"
#
#libs="$libs libjail.so.?"	# 9.3R (/bin/ps)
#libs="$libs libncursesw.so.?"	# 9.3R (/usr/bin/dialog)
#libs="$libs libthr.so.?"	# 9.3R (/usr/local/sbin/smartctl)
#libs="$libs libcxxrt.so.?"	# 10.3R (/usr/local/sbin/smartctl)


libs=`cat /tmp/libs-ldd-uniq.txt | grep '^/lib/' | sed 's+^/lib/++'`
libexecs="ld-elf.so.?"

# /usr/lib
#ulibs="libdialog.so.? libbsm.so.? libstdc++.so.? libusb.so.?"
#ulibs="libdialog.so.? libbsm.so.? libusb.so.? libc++.so.?"
ulibs=`cat /tmp/libs-ldd-uniq.txt | grep '^/usr/lib/' | sed 's+^/usr/lib/++'`

uletcs="kon.cfg"
#ulbins=""
#uletcs=""
vtfonts="paw16vt.fnt paw24vt.fnt paw32vt.fnt"
fonts="paw16a.bdf paw16k.bdf 8x16rk.bdf.gz jiskan16.bdf.gz"

#
# mfsroot.gz κ
#

# ᡼ե
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=10
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=12
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=16
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=20
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=24
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=32
dd if=/dev/zero bs=1m of=/tmp/mfsroot count=36

# 
mdconfig -a -t vnode -f /tmp/mfsroot -u 0
#bsdlabel -B -w md0 auto
bsdlabel -w md0 auto
newfs -i 4096 md0a
# default value of i option: 8192 -> 320 inodes
# 4096 -> 576, 2048 -> 1088 inodes


# ޥ
mount /dev/md0a /mnt
cd /mnt

# FreeBSD Copyright򥳥ԡ
cp /COPYRIGHT /mnt
 
# СϿ
echo "${version}.${minor}" > /mnt/version.txt
echo "$volid ($timestamp)" > /mnt/volume.id


# ̾쥵ӥ
case x"$credit" in
	x)
		rm -f /mnt/credit.txt
		;;
	x*)
		echo "$credit" > /mnt/credit.txt
		;;
esac

# ɬפʥǥ쥯ȥ
cd /mnt
for d in $dirs ; do
	mkdir -p $d
done

# 2020-05-18
cd /mnt
ln -s wipeout menu

chmod 777 /tmp

# /etc 
cd /mnt/etc

# ѥɥȥ
echo 'root::0:0:Charlie &:/:/bin/sh' > /mnt/etc/passwd
echo 'root::0:0::0:0:Charlie &:/:/bin/sh' > /mnt/etc/master.passwd
pwd_mkdb -d /mnt/etc /mnt/etc/master.passwd

# fstab
echo '# device	mount	fstype	options	dump	pass'	>  /mnt/etc/fstab
echo '/dev/md0a	/	ufs	rw	1	1'	>> /mnt/etc/fstab
# 2025-06-22
echo 'proc	/proc	procfs	rw	1	1'	>> /mnt/etc/fstab

etcs="group profile services protocols libmap.conf"
etcs="$etcs login.access login.conf ttys"
for f in $etcs ; do
	cp -p /usr/src/etc.orig/$f /mnt/etc
done

# login.conf
cap_mkdb /mnt/etc/login.conf

#cp -p /usr/src/etc/root/dot.profile /mnt/.profile
cp -p /usr/src/bin/sh/dot.profile /mnt/.profile
echo 'PATH="$PATH:/usr/bin:/usr/sbin:/wipeout"' >> /mnt/.profile
echo 'PATH="$PATH:/bin:/sbin"' >> /mnt/.profile
echo 'PATH="$PATH:/usr/local/bin:/usr/local/sbin"' >> /mnt/.profile
echo 'export PATH' >> /mnt/.profile

cp -p $srcdir/dot.cshrc /mnt/.cshrc

mkdir -p /mnt/root
cp /mnt/.profile /mnt/.cshrc /mnt/root

# wipe-outϢΥե/etc˥ԡ
cd $srcdir
cp $rc /mnt/etc/rc
chmod +x /mnt/etc/rc
#cp $termcap /mnt/etc

# /wipeout ɬפʥե򥳥ԡ
cd $srcdir
cp $binaries /mnt/wipeout
cp $scripts /mnt/wipeout
#for f in $scripts; do
#	nkf -w $f > /mnt/wipeout/$f
#done
cp $misc /mnt/wipeout
#for f in $misc; do
#	nkf -w $f > /mnt/wipeout/$f
#done

cd /mnt/wipeout
chmod +x $scripts

# 2025-06-23
echo 'Copyright (C) 2001-2025 by Dai ISHIJIMA' > COPYRIGHT

# floppyǥݡ
cd /mnt/fd-mode
#(cd $floppydir | tar cf - ./) | tar $taropts -
( cd /home/dai/src/wipe-out/v$version/floppy ; tar cf - . ) | tar $taropts -

# /bin
cd /mnt/bin
for f in $bins ; do
	cp -p /bin/$f .
done
# link
ln 'test' '['
# symlink
for i in `/bin/ls /bin`; do
	if [ ! -f $i ]; then
		ln -s ../cdrom/bin/$i $i
	fi
done

# /sbin
cd /mnt/sbin
for f in $sbins ; do
	cp -p /sbin/$f .
done
# symlink
for i in `/bin/ls /sbin`; do
	if [ ! -f $i ]; then
		ln -s ../cdrom/sbin/$i $i
	fi
done

# /lib
cd /mnt/lib
for f in $libs ; do
	cp -p /lib/$f .
done
# symlink
for i in `/bin/ls /lib`; do
	if [ ! -f $i ]; then
		ln -s ../cdrom/lib/$i $i
	fi
done

# /libexec
cd /mnt/libexec
for f in $libexecs ; do
	cp -p /libexec/$f .
done
# symlink
for i in `/bin/ls /libexec`; do
	if [ ! -f $i ]; then
		ln -s ../cdrom/libexec/$i $i
	fi
done

# /usr/bin
cd /mnt/usr/bin
for f in $ubins ; do
	cp -p /usr/bin/$f .
done
#
####cp -p /usr/src/usr.bin/login/login /mnt/usr.bin/login2 
#
ln id whoami
ln id groups
# vi
#ln -s /cdrom/usr/bin/vi vi
# symlink
for i in `/bin/ls /usr/bin`; do
	if [ ! -f $i ]; then
		ln -s ../../cdrom/usr/bin/$i $i
	fi
done

# /usr/sbin
cd /mnt/usr/sbin
for f in $usbins ; do
	cp -p /usr/sbin/$f .
done
# symlink
for i in `/bin/ls /usr/sbin`; do
	if [ ! -f $i ]; then
		ln -s ../../cdrom/usr/sbin/$i $i
	fi
done

# /usr/lib
cd /mnt/usr/lib
for f in $ulibs ; do
	cp -p /usr/lib/$f .
done
# symlink
for i in `/bin/ls /usr/lib`; do
	if [ ! -f $i ]; then
		ln -s ../../cdrom/usr/lib/$i $i
	fi
done

# other /usr directories
#cd /mnt/usr
#udirs="bin sbin lib libexec"
#for d in $udirs ; do 
#	ln -s /cdrom/usr/$d $d
#done

# /usr/local/bin
cd /mnt/usr/local/bin
for f in $ulbins ; do
	cp -p /usr/local/bin/$f .
done
#ln -s /cdrom/usr/bin/ng ng

# /usr/local/etc
cd /mnt/usr/local/etc
for f in $uletcs ; do
	cp -p /usr/local/etc/$f .
done

# /usr/local/sbin
cd /mnt/usr/local/sbin
for f in $ulsbins ; do
	cp -p /usr/local/sbin/$f .
done

# bdf font
mkdir -p /mnt/usr/local/share/fonts/bdf
for f in $fonts ; do
	cp -p /usr/local/share/fonts/bdf/$f /mnt/usr/local/share/fonts/bdf
done

# vt font
mkdir -p /mnt/usr/local/share/fonts/vt
for f in $vtfonts ; do
	cp -p /usr/local/share/fonts/vt/$f /mnt/usr/local/share/fonts/vt
done

# /var
vars="run/utx.active log/utx.log log/utx.lastlogin"
for f in $vars ; do
	touch /mnt/var/$f
done

# /usr/share/locale
langs="C.UTF-8 en_US.US-ASCII en_US.UTF-8"
langs="$langs ja_JP.SJIS ja_JP.UTF-8 ja_JP.eucJP"
mkdir -p /mnt/usr/share/locale
(cd /usr/share/locale ; tar cf - $langs) |
		(cd /mnt/usr/share/locale ; tar xf -)

langs="C en_US.UTF-8 en_US.US_ASCII POSIX"
langs="$langs ja_JP.SJIS ja_JP.UTF-8 ja_JP.eucJP"
mkdir -p /mnt/usr/share/nls
(cd /usr/share/nls ; tar cf - $langs) |
		(cd /mnt/usr/share/nls ; tar xf -)
#(cd /mnt/usr/share/nls; ln -s C POSIX)


# /usr/share/misc
usms="termcap.db termcap"
for f in $usms ; do
	cp -p /usr/share/misc/$f /mnt/usr/share/misc/$f
done
(cd /mnt/etc; ln -s ../usr/share/misc/termcap)
cp $srcdir/termcap /mnt/usr/share/misc/termcap
cap_mkdb /mnt/usr/share/misc/termcap

# ǥХåѤ mfsroot ¸
if [ -d $mfsroot ]; then
	chflags -R 0 $mfsroot
	rm -rf $mfsroot
fi
mkdir $mfsroot
( cd /mnt; tar cf - . ) | ( cd $mfsroot; tar $taropts - )

# ޥȤư
cd /tmp
umount /mnt
mdconfig -d -u 0
gzip --best < /tmp/mfsroot > /tmp/mfsroot.gz

# 
# ֡ȥ᡼κ
#
if [ -d $cdfs ]; then
	chflags -R 0 $cdfs
	rm -rf $cdfs
fi

# CDΰγ
mkdir -p $cdfs
# FreeBSD Copyright򥳥ԡ
cp /COPYRIGHT $cdfs/COPYRIGHT

mkdir -p $cdfs/boot/kernel
mkdir -p $cdfs/boot/modules
mkdir -p $cdfs/boot/defaults
# 2025-06-23
mkdir -p $cdfs/etc
cp -p /usr/src/etc.orig/group $cdfs/etc
echo 'root::0:0:Charlie &:/:/bin/sh' > $cdfs/etc/passwd
echo 'root::0:0::0:0:Charlie &:/:/bin/sh' > $cdfs/etc/master.passwd
pwd_mkdb -d $cdfs/etc $cdfs/etc/master.passwd

# 2025-06-28
echo '# device	mount	fstype	options	dump	pass'	>  $cdfs/etc/fstab
echo '/dev/md0a	/	ufs	rw	1	1'	>> $cdfs/etc/fstab
echo 'proc	/proc	procfs	rw	1	1'	>> $cdfs/etc/fstab
mkdir -p $cdfs/proc

# 2025-06-28
dirs="bin sbin lib"
for d in $dirs ; do
	mkdir -p $cdfs/$d
	( cd /$d ; tar cf - . ) | ( cd $cdfs/$d ; tar $taropts - )
done

# 12.x
bootdir=/boot
kerndir=/boot/kernel

# ֡Ȥɬפʥե򥳥ԡ (kernelʳ)
cd $bootdir
bootfiles=`/bin/ls | grep -v kernel`
tar cf - $bootfiles | (cd $cdfs/boot; tar $taropts -)

#
cp -p /boot/defaults/loader.conf $cdfs/boot/defaults

# use sc(4) for kon
#grep -v 'kern.vty' /boot/loader.conf |
#	grep -v 'pty_' > $cdfs/boot/loader.conf

#echo 'kern.vty=sc' >> $cdfs/boot/loader.conf
#echo 'pty_load="YES"' >> $cdfs/boot/loader.conf

#### 2021-09-14 #### 12.x/i386 ǥ꤬2G(?)ۤƤ饳? ####
echo 'hw.physmem="1G"' >> $cdfs/boot/loader.conf

# use vt(4) / EFI boot
echo 'hw.vga.textmode=0' > $cdfs/boot/loader.conf
echo 'kern.vty=vt' >> $cdfs/boot/loader.conf
echo 'kern.vt.fb.default_mode="640x480"' >> $cdfs/boot/loader.conf
echo 'exec="gop set 0"' >> $cdfs/boot/loader.conf

# like FreeBSD-12.2-RELEASE-i386-bootonly.iso
echo 'vfs.mountroot.timeout="10"' >> $cdfs/boot/loader.conf
echo 'kernels_autodetect="NO"' >> $cdfs/boot/loader.conf

#
echo 'mfsroot_load="YES"' >> $cdfs/boot/loader.conf
echo 'mfsroot_type="mfs_root"' >> $cdfs/boot/loader.conf
echo 'mfsroot_name="/boot/mfsroot"' >> $cdfs/boot/loader.conf
echo 'mfsroot_before="echo -n '"'"'mfsroot '"'"'"' \
	>> $cdfs/boot/loader.conf
echo 'vfs.root.mountfrom="ufs:/dev/md0a"' >> $cdfs/boot/loader.conf

#
# kernel and modules
#
kerndir=/boot/kernel

kernfiles="kernel linker.hints"

# kernel
for i in $kernfiles; do
 	cp -p $kerndir/$i $cdfs/boot/kernel
done

# modules
kldfiles="$kldfiles acpi pty"
kldfiles="$kldfiles ips siis xhci mps"
kldfiles="$kldfiles ucom uark uchcom uftdi"
kldfiles="$kldfiles umcs umct umodem uplcom speaker"

#
for i in $kldfiles ; do
	if [ -f $kerndir/$i.ko* ]; then
	 	cp -p $kerndir/$i.ko* $cdfs/boot/kernel
	fi
	echo "$i"'_load="YES"' >> $cdfs/boot/loader.conf	
done

cp /tmp/mfsroot.gz $cdfs/boot/mfsroot.gz

# 礭Ǥ $kerndir/* 򥳥ԡ
case x"$size" in
    x[af]*)
	cp -p $kerndir/* $cdfs/boot/kernel
	;;
esac	

# 켰򥳥ԡ
mkdir -p $cdfs/src
cd $srcdir
cp -p * $cdfs/src

# Windows桼˥եJISΥեѰ
for i in $misc ; do
	nkf -s -c $i > $cdfs/$i
done
nkf -s -c /tmp/version.txt > $cdfs/version.txt

mkdir -p $cdfs/sjis
for i in $textfiles ; do
	nkf -s -c $i > $cdfs/sjis/$i
done

cd $appdir
mkdir -p $cdfs/app
for i in $appfiles ; do
	cp -p $i $cdfs/app
done

#
#mkdir -p $cdfs/usr/bin
#cp -p /usr/bin/vi $cdfs/usr/bin
mkdir -p $cdfs/usr/local/bin
#cp -p /usr/local/bin/ng $cdfs/usr/local/bin

# ޥ˥
case x"$size" in
    x[af]*)
	cddirs="bin sbin lib libexec"
	for d in $cddirs ; do
		mkdir -p $cdfs/$d
		cd $cdfs/$d
		(cd /$d; tar cf - . ) | tar $taropts -
	done
	cddirs="bin sbin lib libexec"
	for d in $cddirs ; do
		mkdir -p $cdfs/usr/$d
		cd $cdfs/usr/$d
		(cd /usr/$d; tar cf - . ) | tar $taropts -
	done
	# ä
	cd $cdfs/usr/libexec
	/bin/rm -rf cc1* f77* lpr sendmail sm.bin
	cd $cdfs/usr/lib
	/bin/rm -rf aout compat lib*.a
	cd $cdfs/usr/sbin
	/bin/rm -rf named* dns* lwresd*	
	;;
esac

# ǤΥ᡼ե򥳥ԡ (CD)
case x"$images" in
	xNO)
		;;
	*)
		mkdir -p $cdfs/images
		for i in $images ; do
			if [ -f /tmp/$i ]; then
				cp -p /tmp/$i $cdfs/images
			fi
		done
		;;
esac

# ޥΥե򥳥ԡ (CD)
case x"$auxfiles" in
	xNO)
		;;
	*)
		mkdir -p $cdfs/auxfiles
		for i in $auxfiles ; do
			if [ -f /tmp/$i ]; then
				cp -p /tmp/$i $cdfs/auxfiles
			fi
		done
		;;
esac


# UEFIѡƥ (from /usr/src/release/amd64/mkisoimages.sh)
#cd $cdfs/boot

# Make EFI system partition (should be done with makefs in the future)
#dd if=/dev/zero of=$cdfs/boot/efiboot.img bs=4k count=200
#mdconfig -a -t vnode -f $cdfs/boot/efiboot.img -u 0

# FAT12 / mediadiscriptor 0xf8L
#newfs_msdos -F 12 -m 0xf8 /dev/md0
#mount -t msdosfs /dev/md0 /mnt
#mkdir -p /mnt/EFI/BOOT
#cp $cdfs/boot/boot1.efi /mnt/EFI/BOOT/BOOTX64.EFI
#echo BOOTX64.EFI > /mnt/EFI/BOOT/STARTUP.NSH
#umount /mnt
#mdconfig -d -u 0

# ISO᡼
cd /tmp
#mkisofs -b boot/cdboot -no-emul-boot -c boot.catalog \
#	-r -J -V $volid -o /tmp/$basename.iso $cdfs
#mkisofs -b boot/cdboot -no-emul-boot \
#	-R -U -r -J -V $volid -o /tmp/$basename.iso $cdfs
#mkisofs -v -r -J -U -R -V $volid \
# ------------------------------------------------------------ #
#mkisofs -r -J -U -R -V $volid \
#	-b boot/cdboot -c boot/catalog -no-emul-boot \
#	-eltorito-alt-boot  -eltorito-platform efi \
#	-eltorito-boot boot/efiboot.img -no-emul-boot \
#	-o /tmp/$basename.iso $cdfs
# ------------------------------------------------------------ #
#mkisofs -r -J -U -R -V $volid \
#	-b boot/cdboot -c boot/catalog -no-emul-boot \
#	-o /tmp/$basename.iso $cdfs
# ------------------------------------------------------------ #
#mkisofs -b boot/cdboot -no-emul-boot \
#	-R -U -r -J -V $volid -o /tmp/$basename.iso $cdfs
#makefs -t cd9660 -o 'bootimage=i386;/boot/cdboot' -o no-emul-boot \
#	-o rockridge -o label=WPOUT_21 /tmp/$basename-makefs.iso $cdfs
# ------------------------------------------------------------ #
mkdir -p $cdfs/usr/src/release/amd64/
mkdir -p $cdfs/usr/src/tools/boot
cp -p /usr/src/tools/boot/install-boot.sh $cdfs/usr/src/tools/boot
cp -p $srcdir/mkisoimages.sh $cdfs/usr/src/release/amd64/
sh $cdfs/usr/src/release/amd64/mkisoimages.sh \
	-b $volid /tmp/$basename.iso $cdfs
# ------------------------------------------------------------ #

# USB᡼
case x"$mkusb" in
    xYES)
	cd /tmp
	ncnt=64
	# 64MХȤΥ᡼
	ncnt=300
	# 300MХȤΥ᡼
	ncnt=96
	# 96MХȤΥ᡼
	dd if=/dev/zero of=$usbimg bs=1048576 count=$ncnt

	# ᡼
	nsect=63
	nhead=16
	mdconfig -a -t vnode -f $usbimg -u 0 -x $nsect -y $nhead

	# GPT
	/sbin/gpart create -s GPT md0
	/sbin/gpart bootcode -b /boot/pmbr md0

	# EFI boot partition (TOO Large!)
	#/sbin/gpart add -b 40 -s 472 -t freebsd-boot md0
	# 4 * 1024 * 1024 / 512 - 40 (4MB - 40 sectors)
	#/sbin/gpart add -b 40 -s 8152 -t efi md0
	# 260 * 1024 * 1024 / 512 - 40 = 532440
	# 200 * 1024 * 1024 / 512 - 40 = 409560
	#/sbin/gpart add -b 40 -s 409560 -t efi md0
	#/sbin/gpart bootcode -p /boot/gptboot -i 1 md0
	# FAT32, clustersize:1, label:EFISYS
	#newfs_msdos -F 32 -c 1 -L EFISYS /dev/md0p1
	# FAT16, clustersize:1, label:EFISYS
	#newfs_msdos -F 16 -L EFISYS /dev/md0p1
	#% ----------------
	# 20 * 1024 * 1024 / 512 - 40 = 40920 (20MB - 40 sec)
	/sbin/gpart add -b 40 -s 40920 -t efi md0
	newfs_msdos -F 16 -L EFISYS /dev/md0p1
	#% ----------------
	mount_msdosfs /dev/md0p1 /mnt
	mkdir -p /mnt/EFI/BOOT
	cp /boot/loader.efi /mnt/EFI/BOOT/BOOTX64.efi
	mkdir -p /mnt/EFI/FREEBSD
	cp /boot/loader.efi /mnt/EFI/BOOT/LOADER.efi
	df -h /mnt
	umount /mnt

	# UFS
	/sbin/gpart add -s 64M -t freebsd-ufs md0
	/sbin/newfs -Uj /dev/md0p2

	# FAT
	/sbin/gpart add -t ms-basic-data md0
	newfs_msdos /dev/md0p3

	# FAT data
	newfs_msdos /dev/md0p3
	mount -t msdosfs /dev/md0p3 /mnt
	mkdir /mnt/WIPE-OUT
	cp -p $cdfs/*.txt /mnt
	mkdir /mnt/SJIS
	( cd $cdfs/sjis ; tar cf - . ) | ( cd /mnt/SJIS ; tar $taropts -)
	df -h /mnt
	sync
	umount /mnt

	# UFS data
	mount /dev/md0p2 /mnt
	#
	mkdir /mnt/boot
	( cd $cdfs/boot ; tar cf - . ) | ( cd /mnt/boot ; tar $taropts - )
	df -h /mnt
	sync
	umount /mnt
	gpart list /dev/md0

	# ᡼ڤΥ
	mdconfig -d -u 0
	;;
esac

# 
/bin/rm -f $basename.lzh $basename.tgz
#lha ao5 $basename.lzh $basename.iso
#tar czvf $basename.tgz $basename.iso

#
# ޤ
#
