#! /bin/sh
#
#   erase.sh -- ǡ񤭤ƾä
#
#	0.0: Oct. 30, 2001 by Dai ISHIJIMA (e.sh, for v00)
#	0.1: Oct. 22, 2002 (for v01, variable disk size)
#	0.2: May   1, 2004 (for v02, 0, 1, random)
#	0.3: Jun. 20, 2004 (for v03, menu/floppy)
#	0.4: Feb. 17, 2007 (for v08, ѥ)
#	0.5: May  17, 2020 (for v20, FreeBSD 11.3R)
#

stuff="${1:--z}"
disk="${2:-ada0}"

dmesg=/var/run/dmesg.boot
dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

echo ''; echo ''; echo ''
echo "*** erase data on ${disk} ${dname}, ${bytes} bytes"
echo -n "    with "
case x"$stuff" in
	x-z)	method='write 0'
		echo "writing '0' onto the disk" ;;
	x-f)	method='write 1'
		echo "writing '1' onto the disk" ;;
	x-r)	method='write random'
		echo "writing random data onto the disk" ;;
	x-p)	stuff -g > $PATTERNFIL
		method='write pattern'
		echo "writing random pattern onto the disk" ;;
	x-q)	method='write inverted pattern'
		echo "writing inverted pattern onto the disk" ;;
esac

echo -n "Ok? [y/n]: "
read ans
case x"$ans" in
	xy)	;;
	*)	echo 'canceled'; exit 1;;
esac

echo -n "Really? [yes/no]: "
read ans
case x"$ans" in
	xyes)	;;
	*)	echo 'canceled'; exit 1;;
esac


# õΥѥ᡼
bytes=`disksize -b /dev/$disk`
obs=$(( 1024 * 1024 ))
ibs=1024
icnt=32768
ocnt=32
max=$(( ( $bytes + $obs - 1 ) / $obs ))

#
echo ''

echo ''; echo ''; echo ''; echo ''; echo '';
echo ''; echo ''; echo ''; echo ''; echo '';
echo -e '\e[10A\c'
echo -e '\e7\c'

startsec=`tinydate '+%s'`
rems='??? [min]'

skip=0
while [ $skip -le $max ]; do
	# 
	echo -e '\e8\c'
	echo -e '\e7\c'
	# ׻
	cursec=`tinydate '+%s'`
	# С
	p=$(( 100 * $skip / $max ))
	m=$(( 1000 * $skip / $max ))
	q=$(( $p / 2 ))
	i=0
	bar=''
	while [ $i -lt $q ]; do
		bar="$bar"'#'
		i=$(( $i + 1 ))
	done
	while [ $i -lt 50 ]; do
		bar="$bar"'_'
		i=$(( $i + 1 ))
	done
	#
	# Ĥ
	elapsed=$(( $cursec - $startsec ))
	if [ $m -gt 0 ]; then
		remain=$(( ( 1000 - $m ) * $elapsed / $m + 1 ))
		if [ $remain -gt 120 ]; then
			rems=$(( ( $remain + 59 ) / 60 ))
			rems="${rems} [min]"
		else
			rems="${remain} [sec]"
		fi
	fi
	if [ $elapsed -gt 120 ]; then
		elas=$(( ( $elapsed + 30 ) / 60 ))
		elas="${elas} [min]"
	else
		elas="${elapsed} [sec]"
	fi
	#
	echo "erasing data on disk: ${disk}.  ${p}% done"
	echo "${elas} elapsed, ${rems} remains (approx.)   "
	echo ''
	echo "    0%|${bar}|100%"
	echo ''
	case x$DEBUG in
		x[Yy]*)
			echo 'now in debug mode...'
			sleep 1
			;;
		*)
			stuff $stuff < $PATTERNFIL | dd ibs=$ibs obs=$obs seek=$skip count=$icnt of=/dev/$disk
			;;
	esac
	# 롼
	skip=$(( $skip + $ocnt ))
done

echo ''; echo ''; echo ''; echo ''; echo ''

cursec=`tinydate '+%s'`
elapsed=$(( $cursec - $startsec ))
if [ $elapsed -gt 120 ]; then
	min=$(( $elapsed / 60 ))
	sec=$(( $elapsed - $min * 60 ))
	elas="${min} [min] ${sec} [sec]"
else
	elas="${elapsed} [sec]"
fi

echo 'The contents of this storage device' > /tmp/erase-log.$disk
echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
echo -n 'were erased with ' >> /tmp/erase-log.$disk
echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
echo "Erased with '$method'" >> /tmp/erase-log.$disk
echo " epoch: $startsec -> $cursec" >> /tmp/erase-log.$disk

echo "but NOT verified" > /tmp/verify-log.$disk

echo "completed ($elas)"
echo ''
echo -n 'Press ENTER to return menu...'
read x

exit 0

# EOF
