#! /bin/sh
#
#   startup.sh -- スタートアップスクリプト (日本語化コンソール用)
#
#	0.0: Jun. 15, 2004 by Dai ISHIJIMA
#	0.1: Jun. 19, 2005 (for PXEBOOT)
#	0.2: Aug.  1, 2006 (v07、CD初期化をrcへ、ランダムパターンとその補数)
#	0.3: Aug.  6, 2006 (キーボードチェック)
#	0.4: Sep. 18, 2006 (/var を mkdir しない)
#	0.5: Feb. 10, 2007 (ログ記録 for wpout08)
#	0.6: Sep. 12, 2007 (for wpout09開発版)
#	0.7: Sep. 17, 2007 (shutdown時の画面復帰)
#	0.8: Jan.  3, 2008 (起動時ロジックの改良)
#	0.8: Jul. 24, 2009 (dmesg.bootの重複チェック, wpout10)
#	0.9: Dec.  7, 2013 (ディスクのデバイス名)
#	1.0: Aug.  4, 2015 (ad -> ada, FreeBSD 9.3R)
#	1.1: Jul. 26, 2016 (10.3R, vt -> sc/kon2)
#	1.2: Jul. 13, 2025 (14.2R, vt, EFI, ja_JP.UTF-8)
#

/wipeout/session > /tmp/session.txt
export EPOCH=`sed -n '1p' < /tmp/session.txt`
export SID=`sed -n '2p' < /tmp/session.txt`

echo -n '起動時のシステムメッセージを保存しています...'
dmesg > $DMESG
echo ''

# 「md0」が行頭に現れる行番号を調べる。複数あれば重複
lin1=`sed -n '/^md0/=' $DMESG | sed -n '1p'`
lin2=`sed -n '/^md0/=' $DMESG | sed -n '$p'`

if [ $lin1 -ne $lin2 ]; then
	echo 'システムメッセージが重複しています。'
	echo '一度電源を切ってから再起動することを推奨します。'
	echo '処理を続行する場合は「exit」を入力してください。'
	/bin/sh -i
fi

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script startup.sh started on " >> $LOGFIL
date >> $LOGFIL

# 2013-12-07 names of disk device node
# !ata(4) -> ad (P-ATA: ad0, S-ATA: ad4, etc.)
# ada(4) -> ada (SATA/PATA, FreeBSD 9.3R)
# SCSI (da(4)) -> da (SCSI, CAM)
# ataraid(4) -> ar
# aac(4) -> aacd
# amr(4) -> amrd(?) or da(?) (SCSI CAM)
# arcmsr(4) -> da (SCSI CAM)
# asr(4) -> da(?) (SCSI CAM)
# graid3(4) -> da (SCSI CAM)
# hptiop(4) -> da(?)
# hptmv(4) -> da(?)
# hptrr(4) -> da(?)
# ida(4) -> idad(?), da(?)
# iir(4) -> da(?)
# ips(4) -> ipsd(?), da(?)
# mfi(4) -> mfid
# mlx(4) -> mlxd(?), da(?)
# mly(4) -> da(?)
# twa(4) -> da(?)
# twe(4) -> da(?)
# nda(4) -> nda(?) NVMe Direct Access device
# nvd(4) -> nvd(?) NVM Express disk
export DEVICES='nda|nvd|da|ada|aacd|amrd|idad|ipsd|mfid|mlxd|twed|ad|ar'

# 一度に32Mバイトずつ消す
export BLKLEN=$(( 32 * 1024 * 1024 ))
# 出力ブロック長は1Mバイト
export OBS=$(( 1024 * 1024 ))
# 入力ブロック長 (stuffの出力長) は1kバイト
export IBS=1024
# 消去確認は10Mバイトずつ
export VBLKLEN=$(( 10 * 1024 * 1024 ))
# 消去確認の入力ブロック長は1Mバイト
export VBS=$(( 1024 * 1024 ))
# コピー時は512バイトずつ
export CBS=512

echo ''

# debugging
case x"$DEBUG" in
    x[Yy]*)
	count=5
	prompt='debug wait '
	. /wipeout/ncountdown.sh
	echo ''
	;;
esac

cd /wipeout
stuff -g > $PATTERNFIL
echo "random pattern file $PATTERNFIL generated" >> $LOGFIL

if ! /bin/sh mainmenu.sh ; then
	exit 1
fi

# とりあえず対話シェルを動かしておく :-)
/bin/sh -i

exit 0

# EOF
