#! /bin/sh
#
#   timer.sh -- в֤ɽ
#
#	0.0: May  18, 2020 (for v20, FreeBSD 11.3R)
#

#
opt1="$1"
opt2="$2"

epoch=`date '+%s'`
#sleep 30
lastmin=0
current=`date '+%s'`
elapsed=$(( $current - $epoch ))
min=$(( $elapsed / 60 ))
hh=$(( $elapsed / 3600 ))
mm=$(( ($elapsed - hh * 3600) / 60 ))
ss=$(( $elapsed - hh * 3600 - $mm * 60 ))

trap '/bin/sh show-elapsed.sh "$elapsed"; exit 0' 1 2 15

sleep 10

while true; do
	echo -e "\r\c"
	current=`date '+%s'`
	elapsed=$(( $current - $epoch ))
	min=$(( $elapsed / 60 ))
	hh=$(( $elapsed / 3600 ))
	mm=$(( ($elapsed - hh * 3600) / 60 ))
	ss=$(( $elapsed - hh * 3600 - $mm * 60 ))
	if [ $elapsed -le 60 ]; then
		case "x${elapsed}x" in
			x*[0]x)
				echo $1 "$elapsed [sec]" "$2"
				;;
		esac
	elif [ $elapsed -le 120 ]; then
		mod2=$(( $elapsed - ($elapsed / 20 ) * 20 ))
		if [ $mod2 -eq 0 ]; then
			echo $1 "$elapsed [sec]" "$2"
		fi
	elif [ $elapsed -le 600 ]; then
		if [ $ss -eq 0 ]; then
			if [ $lastmin -le $min ]; then
				echo $1 "$min [min]" "$2"
			fi
		fi
	elif [ $elapsed -le 1800 ]; then
		mod2=$(( $min - ($min / 5) * 5 ))
		if [ '(' $ss -eq 0 ')' -a '(' $mod2 -eq 0 ')' ]; then
			if [ $lastmin -le $min ]; then
				echo $1 "$min [min]" "$2"
			fi
		fi
	elif [ $elapsed -le 3600 ]; then
		mod2=$(( $min - ($min / 15 ) * 15 ))
		if [ '(' $ss -eq 0 ')' -a '(' $mod2 -eq 0 ')' ]; then
			if [ $lastmin -le $min ]; then
				echo $1 "$min [min]" "$2"
			fi
		fi
	else
		mod2=$(( $min - ($min / 30 ) * 30 ))
		if [ '(' $ss -eq 0 ')' -a '(' $mod2 -eq 0 ')' ]; then
			if [ $lastmin -le $min ]; then
				echo $1 "$min [min]" "$2"
			fi
		fi
	fi
	sh poko.sh
	lastmin=$min
	sleep 1
done

exit 0

# EOF
