/*
 *  check -- ǡõƤ뤫Ĵ٤
 *
 *  revision history:
 *	0.0: Oct. 26, 2001 by Dai ISHIJIMA
 *	0.1: May   1, 2004
 *	0.2: Jul.  7, 2005
 *	0.3: Sep. 12, 2007 (for wpout09, FreeBSD 6.2R)
 *	0.4: Sep. 23, 2021 (for wpout21, FreeBSD 12.2R)
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

#define YES 1
#define NO  0

#define EOS '\0'

#ifndef BUFSIZ
#define BUFSIZ 512
#endif

#define BSIZ 1024
#define NCHARS 256

#define ERROR	5	/* äƤʤ */
#define OK	0	/* 0ǾäƤ */
#define ONE	1	/* 1ǾäƤ */
#define NONZERO	2	/* Ʊ */
#define RANDOM	3	/* ǾäƤ */

#define shift --argc; ++argv


/* ͤʸѴ */
char *num2str(long long d, char *s)
{
    int p;
    int q;
    int ch;

    p = 0;
    do {
	s[p] = '0' + (d % 10);
	++p;
	d /= 10;
    } while (d > 0);
    s[p] = EOS;
    for (q = 0; q < p / 2; q++) {
	ch = s[q];
	s[q] = s[p - q - 1];
	s[p - q - 1] = ch;
    }
    return(s);
}


/* ʸ */
void putch(int fd, unsigned char ch)
{
    write(fd, &ch, 1);
}


/* ʸ */
void myputs(int fd, char *s)
{
    while (*s) {
	putch(fd, *s);
	++s;
    }
}


/* ƥХȤνи */
int chkfreq(int len, unsigned char buf[])
{
    int freq[NCHARS];
    int f, i;

    for (i = 0; i < NCHARS; i++) {
	freq[i] = 0;
    }
    for (i = 0; i < len; i++) {
	++freq[buf[i]];
    }
    f = freq[0];
    for (i = 0; i < NCHARS; i++) {
	if (f != freq[i]) {
	    break;
	}
    }
    if (i >= NCHARS) {
	return(YES);
    }
    return(NO);
}


int main(int argc, char *argv[])
{
    char s[BSIZ];
    unsigned char buf[BSIZ];
    unsigned char last;
    int n;
    int i, j;
    int isrand = NO;
    int verbose = YES;

    shift;
    while ((argc > 0) && (argv[0][0] == '-')) {
	if (argv[0][1] == 'v') {
	    verbose = YES;
	}
	else if (argv[0][1] == 's') {
	    verbose = NO;
	}
	else {
	    myputs(STDERR_FILENO, "Usage: check [-v|-s]\n");
	    exit(1);
	}
	shift;
    }
    last = 0;
    i = 0;
    while ((n = read(STDIN_FILENO, buf, BSIZ)) > 0) {
	if ((isrand = chkfreq(n, buf)) == YES) {
	    i += n;
	}
	else {
	    if ((i > 0) && (last != buf[0])) {
		if (verbose) {
		    myputs(STDOUT_FILENO, "not erased at ");
		    num2str(i, s);
		    myputs(STDOUT_FILENO, s);
		    myputs(STDOUT_FILENO, "\n");
		}
		exit(ERROR);
	    }
	    ++i;
	    for (j = 1; j < n; j++) {
		if (buf[j] != buf[j - 1]) {
		    if (verbose) {
			myputs(STDOUT_FILENO, "not erased at ");
			num2str(i, s);
			myputs(STDOUT_FILENO, s);
			myputs(STDOUT_FILENO, "\n");
		    }
		    exit(ERROR);
		}
		++i;
	    }
	}
	last = buf[n - 1];
    }
    if (verbose) {
	num2str(i, s);
	myputs(STDOUT_FILENO, s);
    }
    if (isrand) {
	if (verbose) {
	    myputs(STDOUT_FILENO, " bytes erased with RANDOM\n");
	}
	exit(RANDOM);
    }
    if (last == 0x00ff) {
	if (verbose) {
	    myputs(STDOUT_FILENO, " bytes erased with 1\n");
	}
	exit(ONE);
    }
    if (last != 0) {
	if (verbose) {
	    myputs(STDOUT_FILENO, " bytes may be erased, but not zero\n");
	}
	exit(NONZERO);
    }
    if (verbose) {
	myputs(STDOUT_FILENO, " bytes erased with 0\n");
    }
    exit(0);
}

/* Local Variables: */
/* compile-command:"cc -Wall -O -static -o check check.c" */
/* End: */
