#! /bin/sh
#
#   sanitize.sh -- camcontrol sanitize でデータを消去する
#
#	使い方: /bin/sh sanitize.sh ディスク
#		例: /bin/sh sanitize da0
#
#	0.0: Aug.  4, 2015 by Dai ISHIJIMA (for wpout15, FreeBSD 9.3R)
#	0.1: Aug. 12, 2025(for wpout25, 14.2R, ja_JP.UTF-8)
#

ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
exec 2>> $ERRORLOG
echo "# start $0, $@" 1>&2
echo '# ---------------------------- #' 1>&2

# 単独でも動くように
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

echo "starting scsi sanitize ($TTYNAME)" > $STATEFIL

#
method="${1:-crypto}"
disk="${2:-da0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"

#
resultfil=/tmp/result

#
title="${TITLE:-ハードディスク消去ツール『wipe-out』}"

#
if [ ! -w /dev/$disk ]; then
	dialog	--title "$title" \
		--msgbox "ディスク $disk が存在しないか、書き込みできません" \
		5 64
	exit 1
fi

#
mount -p | sed -n -E "/^.dev.$disk/p" > $resultfil
if [ -s $resultfil ]; then
	dialog	--title "$title" \
	    --msgbox "マウント中のディスク $disk を消去することはできません" \
	    5 64
	exit 1
fi

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

msg="ディスク ${disk} ${dname} の\n"
msg="${msg}全データ ${bytes}バイトを、\n"
msg="${msg}サニタイズ機能 (Sanitize Device Feature) で消去します。\n"
msg="${msg}\n                      よろしいですか?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac


msg="ATAデバイスやUSB接続のデバイス、新しくないSCSIデバイスでは\n"
msg="${msg}サニタイズ (SCSI Sanitize) が動作しなかったり\n"
msg="${msg}正常終了してもデータの消去が実行されていないことがあります。\n"
msg="${msg}\n                      よろしいですか?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac


msg="本当に${disk} ($cap) のデータをサニタイズしていいですか?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac

dialog	--title "$title" \
	--infobox 'ディスクをサニタイズしています' 3 64

sleep 2

# 開始時刻
startstamp=`date '+%Y-%m-%d %H:%M'`

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "sanitize $method ($TTYNAME) started on " >> $LOGFIL
date >> $LOGFIL

echo "erasing $disk with scsi sanitize ($TTYNAME)" > $STATEFIL

date '+%s' > /tmp/secure-stamp-${TTYNAME}.txt
sh waitsecure.sh /tmp/secure-stamp-${TTYNAME}.txt &
echo "sanitize $method $disk ($dname) $bytes bytes" >> $LOGFIL
script /tmp/sanitize-${TTYNAME}.txt \
	/sbin/camcontrol sanitize $disk -a $method -y
case x"$?" in
	x0)
		status="finished"
		echo "サニタイズは正常終了しました。" > /tmp/sanitizemsg.txt
		;;
	*)
		status="failed"
		echo "サニタイズは動作しませんでした。" > /tmp/sanitizemsg.txt
		;;
esac
cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
echo '' >> $LOGFIL
echo '::: Sanitize (camcontrol output) :::' >> $LOGFIL
nkf -d /tmp/sanitize-${TTYNAME}.txt >> $LOGFIL

echo 'コマンド実行時のログは以下のとおりです。' >> /tmp/sanitizemsg.txt
#echo '↓↑キーでスクロールします。' >> /tmp/sanitizemsg.txt
echo '' >> /tmp/sanitizemsg.txt
echo '/* ======== */' >> /tmp/sanitizemsg.txt
nkf -d /tmp/sanitize-${TTYNAME}.txt >> /tmp/sanitizemsg.txt

echo "show result of scsi sanitize ($TTYNAME)" > $STATEFIL

sh dummyread.sh
dialog	--title 'SCSIサニタイズのログ' --textbox /tmp/sanitizemsg.txt 19 76

#

echo -n "sanitize $status on " >> $LOGFIL
date >> $LOGFIL
echo "sanitize $disk ($dname, $cap)" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

# 終了時刻
endstamp=`date '+%H:%M'`

case x"$status" in
    xfinished)
	# ログ保存
	echo 'The contents of this storage device' > /tmp/erase-log.$disk
	echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
	echo -n 'were erased with ' >> /tmp/erase-log.$disk
	echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
	echo "Erased with 'SANITIZE'" >> /tmp/erase-log.$disk
	echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk
	echo "but NOT verified" > /tmp/verify-log.$disk
	;;
esac

#
echo '# ---------------------------- #' 1>&2

exit 0

# EOF
