#! /bin/sh
#
#   kon2alt.sh -- start kon2 on another VTY session
#	0.0: Aug.  7, 2015 (v1.5)
#	0.1: Nov. 23, 2016 (v1.6)
#
#   vt-alt.sh -- start wipe-out on another VTY session
#	0.2: Sep. 19, 2025 (v2.5)
#

PATH=/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/sbin:/usr/local/bin:/wipeout:.
export PATH

TTY=`/usr/bin/tty | sed 's|^/dev/||'`
export TTY="${TTY:-ttyv0}"

export LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"

n=`echo "$TTY" | sed 's/^.*\([0-9]\)/\1/'`
n=$(( $n + 1 ))
m=$(( $n + 1 ))
ntty=`echo $TTY | sed 's/[0-9]$/'"$n"'/'`

case x"$n" in
    x[0-6])
	echo ''
	echo "Starting new console session on VTY$n (Alt+F$m)"
	/wipeout/shell-on /dev/$ntty
	echo 'You can start another wipe-out session with "sh vt-alt.sh"' \
		> /dev/$ntty
	vidcontrol -f $VTFONT < /dev/$ntty
	echo -n "Starting console session on VTY$n" >> $LOGFIL
	date >> $LOGFIL
	;;
esac
sleep 2

# 2025-09-19
/bin/sh /wipeout/startup.sh

echo -n "vstart.sh finished, " >> $LOGFIL
date >> $LOGFIL

exit 0

# EOF
