#! /bin/sh
#
#   seldisk.sh - ǥ (floppy)
#
#	0.0: Jun. 19, 2004 by Dai ISHIJIMA
#	0.1: May  17, 2020 (for v20, FreeBSD 11.3R)
#

dmesg="${DMESG:-/var/run/dmesg.boot}"
devices="${DEVICES:-ada|da}"

resultfil=/tmp/result
sed -n -E "/^(${devices})[0-9]:.*B [(<]/p" $dmesg |
	sed 's/^\([a-z][a-z]*[0-9]\).*/\1/' > $resultfil
disks=`cat $resultfil`

echo ''; echo ''; echo ''
echo '*** select a disk to erase data'
echo ''
n=0
m=0
for d in $disks ; do
	dname=`sed -n -E "/^${d}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	bytes=`disksize -B /dev/$d`
	cap=`disksize -p /dev/$d`
	echo "    $n: $d $dname $bytes bytes ($cap)"
	m=$n
	n=$(( $n + 1 ))
done
echo ''
echo -n "which drive to erase data? [0-$m]: "
read ans

case x"$ans" in
	x[0-$m])
		n=0;
		for d in $disks ; do
			if [ "$n" = "$ans" ]; then
				break
			fi
			n=$(( $n + 1 ))
		done
		;;
	*)
		d=$disk
		;;
esac

disk=$d

# EOF
