/*
 *  tinydate.c
 *
 */

#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>


#define USE_CTIME

#define EOS '\0'
#define NEWLINE '\n'

#ifndef BUFSIZ
#define BUFSIZ 512
#endif

/* ͤʸѴ */
char *num2str(long long d, char *s)
{
    int p;
    int q;
    int ch;

    p = 0;
    do {
	s[p] = '0' + (d % 10);
	++p;
	d /= 10;
    } while (d > 0);
    s[p] = EOS;
    for (q = 0; q < p / 2; q++) {
	ch = s[q];
	s[q] = s[p - q - 1];
	s[p - q - 1] = ch;
    }
    return(s);
}


/* ʸ */
void putch(int fd, unsigned char ch)
{
    write(fd, &ch, 1);
}


/* ʸ */
void myputs(int fd, char *s)
{
    while (*s) {
	putch(fd, *s);
	++s;
    }
}


int main(int argc, char *argv[])
{
    char s[BUFSIZ];
    time_t t;
#ifdef USE_LOCALTIME
    struct tm *lt;
#endif

    if ((argc > 1) && (argv[1][0] == '-')) {
#ifdef USE_CTIME
	t = time(NULL);
	myputs(STDOUT_FILENO, ctime(&t));
#endif
#ifdef USE_LOCALTIME
	t = time(NULL);
	lt = localtime(&t);
	num2str(lt->tm_year + 1900, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, '-');
	num2str(lt->tm_mon + 1, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, '-');
	num2str(lt->tm_mday, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, ' ');
	num2str(lt->tm_hour, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, ':');
	num2str(lt->tm_min, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, ':');
	num2str(lt->tm_sec, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, ':');
#endif
    }
    else {
	num2str(time(NULL), s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    exit(0);
}

/* Local Variables: */
/* compile-command:"cc -Wall -O -s -static -o tinydate tinydate.c" */
/* End: */
